# Changelog

All notable changes to the HelloPack Client plugin will be documented in this file.

## [2.1.5] - 2025-10-17

### Module Improvements

**Elementor Pro Translation Management**
- Implemented intelligent translation version checking via HelloPack API
- Translation updates now only appear when a newer version is available on the server
- Added PO-Revision-Date based version comparison for accurate update detection
- Optimized API calls with 12-hour caching to reduce server load

**Technical Improvements**
- Compares server PO-Revision-Date with installed translation version
- Prevents unnecessary translation downloads when versions match
- Improved performance with transient-based caching

**Breaking Changes**: None - all changes are backward compatible

---

## [2.1.4] - 2025-10-17

### Module Improvements

**Module System Enhancements**
- Added missing version properties to ensure complete module metadata
- Improved module initialization patterns

**Affected Modules**
- Complianz GDPR Premium - Category fix
- Crocoblock - Category fix
- Divi Responsive Helper - Category fix, added version property
- Divi Tools - Category fix
- Fluent Booking Pro - Category fix
- Fluent CRM - Category fix
- Fluent Support Pro - Category fix
- FluentForm Signature - Category fix
- FluentForm Pro - Category fix
- FluentForms PDF - Category fix
- GenerateBlocks Pro - Category fix
- GP Premium - Category fix
- Gravity Forms - Fixed class naming, category fix, split from Gravity SMTP
- Gravity SMTP - New separate module (split from Gravity Forms)
- JetHelloPack - Category fix
- JetFormBuilder - Category fix
- JS Composer (WPBakery) - Category fix
- MainWP - Category fix
- Meta Box - Category fix
- Ninja Forms - Category fix
- Oxy Composite Elements - Category fix, added version property
- Silent Mode - Category fix
- WP Grid Builder - Added ID, version, and target properties
- WP SEOPress Pro - Added ID, version, and target properties
- WPAlliee - Added ID, version, and target properties
- YITH Infinite Scrolling Premium - Added ID, version, and target properties
- YITH WooCommerce Ajax Product Filter Premium - Added ID, version, and target properties
- YITH WooCommerce Customize MyAccount Page - Added ID, version, and target properties
- Yoast Pro - Added ID, version, and target properties

**Code Quality**
- Removed debug logging statements for cleaner production code
- Enhanced module loader with better special character replacements (HelloPack, ACF, WP, SEO)
- Improved module architecture documentation in CLAUDE.md

**Breaking Changes**: None - all changes are backward compatible

---

## [2.1.3] - 2025-10-16

### Bug Fixes

**Elementor Pro Module**
- Fixed an issue where Elementor Pro translations were incorrectly attempted to download during unrelated plugin updates
- Improved translation update logic to only trigger during actual Elementor Pro updates
- Enhanced update context detection for single plugin updates, bulk updates, and HelloPack-initiated updates

### Module Improvements

- Optimized Elementor Pro module to prevent unnecessary translation API calls
- Better handling of WordPress update transients for translation management

**Breaking Changes**: None

---

## [2.1.2] - 2025-10-16

### Security Update

Minor security enhancements and code quality improvements.

### Security Improvements

- Additional input validation hardening across module system
- Enhanced security measures in core functionality
- Improved code documentation and inline security comments

### Module Updates

- Minor stability improvements for all supported modules
- Optimized license validation processes

**Breaking Changes**: None

---

## [2.1.1] - 2025-10-16

### Critical Security Release

This is a critical security update addressing multiple vulnerabilities discovered during comprehensive security audit. All users are strongly encouraged to update immediately.

### Security Fixes

- Fixed multiple critical and high-priority security vulnerabilities in core plugin files
- Enhanced input validation and sanitization across the entire codebase
- Improved authorization checks for admin operations
- Strengthened data handling and output escaping mechanisms
- Removed deprecated code with potential security risks

### Module Improvements

**New Modules Added**
- FluentCart Pro - Full license management and update support

**Enhanced Modules**
- Elementor Pro - Improved input validation and security hardening
- WP Rocket - Enhanced license data handling and cache management
- TutorLMS Pro - Refined update hook management for better compatibility

**General Module Enhancements**
- Enhanced license management across multiple premium plugin modules
- Improved compatibility and stability for all supported plugins
- Better error handling and validation in module operations
- Optimized caching strategies to reduce API calls

### Performance Optimizations

- Reduced unnecessary API calls through better caching strategies
- Optimized module loading with lazy initialization patterns
- Streamlined license verification process
- Improved memory management and resource cleanup

**Breaking Changes**: None - all fixes are backwards compatible

**Upgrade Note**: This is a security release. Please update immediately. No manual intervention required.

## [2.1.0] - 2025-10-15

### Major Release: Enhanced Security & Module System

This release represents a significant milestone in the HelloPack Client evolution, introducing a powerful module management system and critical security enhancements.

### New Features

**Revolutionary Module System**
- Introducing support for **50+ premium WordPress plugins** with dedicated centralized update modules
- Automatic module detection and loading based on your active plugins
- Beautiful new module management interface with real-time status badges
- Seamless integration with popular plugins like Elementor Pro, WP Rocket, ACF Pro, and many more

**Improved Reliability**
- Smart scheduled authorization checks with custom 10-minute intervals
- Automatic connection maintenance to ensure uninterrupted service
- Enhanced healthcheck system with visual loading indicators
- Built-in cURL availability verification

### User Interface Improvements

- **Redesigned module panel** with modern styling and intuitive layout
- Enhanced table design for better readability and user experience
- Refined button styling and spacing throughout the interface
- Real-time status badges for instant module state visibility

### Security Enhancements

**Critical Security Fixes**
- Enhanced network settings security with proper data validation
- Strengthened overall plugin security posture

### Internationalization

- Significantly improved Hungarian translation coverage
- Fixed missing translator comments in POT file
- Better support for multilingual WordPress installations

### Bug Fixes

- Fixed an issue where Elementor Pro Hungarian translation was unnecessarily updated during unrelated plugin installations
- Improved API connection error messaging for better troubleshooting
- Fixed various edge cases in module loading

### Performance Optimizations

- Streamlined module loading process
- Optimized API communication
- Reduced memory footprint for large installations

This release sets a new standard for WordPress plugin management, combining enterprise-grade security with an intuitive user experience.

## [2.0.35] - 2025-06-13

### Changed
- Update WP_CACHE setting to false in configuration
- Add 'tab' parameter support to pagination links

### Added
- Add TUTOR_DEV_MODE constant to enable developer mode

## [2.0.34] - 2025-05-13

### Added
- Implement Docker cron job for WP-Cron execution
- Add scheduled authorization check with custom cron interval for reauthorization
- Add cURL availability check in system requirements
- Add healthcheck loading indicator in admin UI

### Fixed
- Enhance error messaging for API connection failures

## [2.0.33] - 2025-05-12

### Fixed
- Fix issue where some modules were loading on network admin pages
- Improve module loading logic for better performance

## [2.0.32] - 2025-05-10

### Fixed
- Fix critical issue preventing plugin removal from HelloPack interface
- Restore proper functionality for the remove button in plugin management

## [2.0.31] - 2025-05-10

### Changed
- Improve table styling for module display interface
- Update module panel UI with enhanced visual design
- Refine button layout and spacing in HelloPack cards

## [2.0.30] - 2025-05-09

### Fixed
- Remove duplicate module loading to prevent conflicts
- Optimize module initialization process

## [2.0.29] - 2025-05-09

### Added
- Implement comprehensive module management system
- Add support for centralized plugin updates
- Introduce module status badges in admin interface

## [2.0.28] - 2025-05-09

### Fixed
- Fix missing translators comments in POT file
- Improve internationalization support

## [2.0.27] - 2025-05-07

### Added
- Add 50+ new modules for premium plugin support including:
  - Perfmatters optimization module
  - Thrive Themes suite modules
  - Various form builder modules (Gravity Forms, WPForms, etc.)
  - Page builder addon modules
  - SEO and marketing tool modules
  - Security and backup solution modules

## [2.0.26] - 2025-05-06

### Fixed
- Fix PHP 8.2 compatibility issue with dynamic property creation
- Add #[AllowDynamicProperties] attribute to main class

## [2.0.25] - 2025-04-23

### Fixed
- Correct module file naming convention
- Rename misnamed module files for consistency

## [2.0.24] - 2025-04-23

### Added
- Add comprehensive module system with 30+ premium plugin modules
- Implement automatic module loading based on active plugins
- Add modules for popular plugins like Elementor Pro, WP Rocket, ACF Pro, etc.

## [2.0.23] - 2025-04-21

### Added
- Add Ninja Forms module for centralized update management

## [2.0.22] - 2025-04-17

### Added
- Add WP Mail SMTP Pro module support

## [2.0.21] - 2025-04-17

### Added
- Add Admin Menu Editor Pro module
- Implement license management for Admin Menu Editor Pro

## [2.0.20] - 2025-03-31

### Added
- Add Tutor LMS Pro module with license activation support
- Implement automatic license management for Tutor LMS

## [2.0.19] - 2025-03-24

### Added
- Add WooCommerce Product Filter (WooBeWoo) module

## [2.0.18] - 2025-03-07

### Fixed
- Fix compatibility issue with Gravity Perks activation
- Improve Gravity Forms integration stability

## [2.0.17] - 2025-03-06

### Added
- Add admin notification cleaner feature
- Implement automatic cleanup of redundant admin notices

## [2.0.16] - 2025-03-06

### Added
- Add Hide My WP Ghost module support

## [2.0.15] - 2025-02-29

### Fixed
- Improve error handling for missing API responses
- Enhance API communication reliability

## [2.0.14] - 2025-02-24

### Added
- Add Gravity Perks module for Gravity Forms addon management

## [2.0.13] - 2025-02-17

### Added
- Add SearchWP module for search functionality enhancement

## [2.0.12] - 2025-02-16

### Added
- Add Gravity Forms module with automatic updates

## [2.0.11] - 2025-02-10

### Fixed
- Fix various minor bugs and improve stability
- Enhance error logging for better debugging

## [2.0.10] - 2025-02-10

### Added
- Add TranslatePress module for multilingual support

## [2.0.9] - 2025-02-08

### Added
- Implement plugin installation from HelloPack repository
- Add progress indicators for plugin downloads

## [2.0.8] - 2025-02-07

### Added
- Add theme installation support from HelloPack
- Implement theme management interface

## [2.0.7] - 2025-02-06

### Fixed
- Fix network activation issues on multisite installations
- Improve multisite compatibility

## [2.0.6] - 2025-02-05

### Added
- Add WP-CLI command support for HelloPack management
- Implement CLI commands for status checking and updates

## [2.0.5] - 2025-02-04

### Fixed
- Fix API authentication issues with certain server configurations
- Improve token validation process

## [2.0.4] - 2025-02-03

### Added
- Add automatic migration from HelloPack v1
- Implement legacy settings import functionality

## [2.0.3] - 2025-02-02

### Fixed
- Fix JavaScript errors in admin interface
- Improve AJAX request handling

## [2.0.2] - 2025-02-01

### Added
- Add Hungarian language support
- Include initial Hungarian translations

## [2.0.1] - 2025-01-31

### Fixed
- Fix activation issues on certain hosting environments
- Improve PHP compatibility checks

## [2.0.0] - 2025-01-30

### Added
- Complete rewrite of HelloPack Client
- Implement OAuth token-based authentication
- Add modern admin interface with improved UX
- Add support for automatic updates
- Implement plugin and theme management
- Add network/multisite support

### Changed
- Migrate from API key to token-based authentication
- Redesign entire admin interface
- Improve API communication efficiency

### Removed
- Remove legacy API key authentication method
- Remove outdated admin interface components

## [1.2.16] - 2024-08-15

### Fixed
- Fix multisite network admin compatibility issues
- Improve network activation handling

## [1.2.15] - 2024-07-20

### Added
- Add support for custom plugin directories
- Implement flexible path resolution

## [1.2.14] - 2024-07-10

### Fixed
- Fix update notifications not showing for certain plugins
- Improve update check reliability

## [1.2.13] - 2024-06-25

### Added
- Add debug mode for troubleshooting
- Implement detailed error logging

## [1.2.12] - 2024-06-15

### Fixed
- Fix compatibility with WordPress 6.6
- Update deprecated function calls

## [1.2.11] - 2024-05-30

### Added
- Add support for beta version updates
- Implement version channel selection

## [1.2.10] - 2024-05-20

### Fixed
- Fix memory issues with large plugin lists
- Optimize API response handling

## [1.2.9] - 2024-05-10

### Added
- Add bulk update functionality
- Implement queue system for updates

## [1.2.8] - 2024-04-25

### Fixed
- Fix SSL certificate verification issues
- Improve HTTPS handling

## [1.2.7] - 2024-04-15

### Added
- Add plugin compatibility checker
- Implement version conflict detection

## [1.2.6] - 2024-04-05

### Fixed
- Fix timeout issues with slow connections
- Increase API timeout limits

## [1.2.5] - 2024-03-20

### Added
- Add automatic backup reminder before updates
- Implement safety check system

## [1.2.4] - 2024-03-10

### Fixed
- Fix issue with special characters in API keys
- Improve input validation

## [1.2.3] - 2024-02-25

### Added
- Add support for WordPress 6.5
- Update compatibility checks

## [1.2.2] - 2024-02-15

### Fixed
- Fix JavaScript conflicts with other plugins
- Improve script isolation

## [1.2.1] - 2024-02-05

### Added
- Add performance optimizations
- Implement caching for API responses

## [1.2.0] - 2024-01-25

### Added
- Major update with improved API integration
- Add support for multiple API endpoints
- Implement failover system

### Changed
- Redesign settings page
- Improve user experience

### Fixed
- Fix various compatibility issues
- Improve error handling