<?php
/**
 * Modules partial
 *
 * @package HelloPack_Client
 * @since 2.1.0
 */

$module_loader = HelloPack_Module_Loader::get_instance();
$modules = $module_loader->get_modules();
$settings = $module_loader->get_module_settings();

// Group modules by category
$grouped_modules = array();
foreach ( $modules as $module ) {
	$category = $module->get_category();
	if ( ! isset( $grouped_modules[ $category ] ) ) {
		$grouped_modules[ $category ] = array();
	}
	$grouped_modules[ $category ][] = $module;
}

// Sort categories
ksort( $grouped_modules );
?>

<div id="modules" class="panel">
	
	<div class="hellopack-builder-important-notice hellopack-template-builder hellopack-db-card hellopack-db-card-first">
		<div class="intro-text">
			<h1 class="hellopack-panel-title">
				<svg class="hellopack-box-icon">
					<use xlink:href="<?php echo HELLOPACK_CLIENT_URI . 'images/sprite.svg'; ?>?v=<?php echo HELLOPACK_CLIENT_VERSION; ?>#hellopack-box-icon"></use>
				</svg>
				<?php esc_html_e( 'Modules', 'hellopack-client' ); ?>
			</h1>
			<p><?php esc_html_e( 'Manage HelloPack modules for enhanced functionality with your plugins and themes.', 'hellopack-client' ); ?></p>
		</div>
	</div>
	
	<?php if ( isset( $_GET['updated'] ) && $_GET['updated'] === 'true' ) : ?>
		<div class="hellopack-notice notice notice-success is-dismissible">
			<p><?php _e( 'Module settings updated successfully.', 'hellopack-client' ); ?></p>
		</div>
	<?php endif; ?>
	
	<?php if ( empty( $modules ) ) : ?>
		<div class="hellopack-builder-important-notice hellopack-template-builder hellopack-db-card">
			<div class="notice notice-info inline">
				<p><?php _e( 'No modules found. Modules will appear here once they are added to the modules directory.', 'hellopack-client' ); ?></p>
			</div>
		</div>
	<?php else : ?>
		<div class="hellopack-client-columns">
			<?php foreach ( $grouped_modules as $category => $category_modules ) : ?>
				<div class="hellopack-builder-important-notice hellopack-template-builder hellopack-db-card">
					<h3 class="hellopack-module-category-title">
						<?php echo esc_html( ucfirst( $category ) . ' ' . __( 'Modules', 'hellopack-client' ) ); ?> <span class="hellopack-module-count">(<?php echo count( $category_modules ); ?>)</span>
					</h3>
					
					<table class="wp-list-table widefat striped hellopack-modules-table">
							<thead>
								<tr>
									<th scope="col" class="manage-column column-name"><?php _e( 'Module', 'hellopack-client' ); ?></th>
									<th scope="col" class="manage-column column-target"><?php _e( 'Target', 'hellopack-client' ); ?></th>
									<th scope="col" class="manage-column column-status"><?php _e( 'Status', 'hellopack-client' ); ?></th>
									<th scope="col" class="manage-column column-actions"><?php _e( 'Actions', 'hellopack-client' ); ?></th>
								</tr>
							</thead>
							<tbody>
								<?php foreach ( $category_modules as $module ) : 
									$module_info = $module->get_info();
									$module_id = $module_info['id'];
									$is_enabled = ! isset( $settings[ $module_id ] ) || $settings[ $module_id ]['enabled'] !== false;
									$is_active = $module_info['active'];
									$is_hard_disabled = isset( $module_info['hard_disabled'] ) ? $module_info['hard_disabled'] : false;
									$target = $module_info['target'];
									?>
									<tr>
										<td class="column-name">
											<strong><?php echo esc_html( $module_info['name'] ); ?></strong>
											<br />
											<span class="description"><?php echo esc_html( $module_info['description'] ); ?></span>
										</td>
										<td class="column-target">
											<?php 
											if ( 'plugin' === $category && isset( $target['plugin_dir'] ) ) {
												echo esc_html( $target['plugin_dir'] );
											} elseif ( 'theme' === $category && isset( $target['theme_slug'] ) ) {
												echo esc_html( $target['theme_slug'] );
											} else {
												echo '—';
											}
											?>
										</td>
										<td class="column-status">
											<span class="hellopack-module-status-badge" data-module-id="<?php echo esc_attr( $module_id ); ?>">
												<?php if ( $is_hard_disabled ) : ?>
													<span class="badge-hard-disabled" style="color: #fff; background-color: #6c757d; padding: 4px 8px; border-radius: 4px; display: inline-block;">
														<?php _e( 'Disabled', 'hellopack-client' ); ?>
													</span>
												<?php elseif ( $is_active && $is_enabled ) : ?>
													<span class="badge-active" style="color: #fff; background-color: #23d160; padding: 4px 8px; border-radius: 4px; display: inline-block;">
														<?php _e( 'Active', 'hellopack-client' ); ?>
													</span>
												<?php elseif ( ! $is_enabled ) : ?>
													<span class="badge-disabled" style="color: #fff; background-color: #ff3960; padding: 4px 8px; border-radius: 4px; display: inline-block;">
														<?php _e( 'Disabled', 'hellopack-client' ); ?>
													</span>
												<?php else : ?>
													<span class="badge-ready" style="color: #fff; background-color: #198fd9; padding: 4px 8px; border-radius: 4px; display: inline-block;">
														<?php _e( 'Ready', 'hellopack-client' ); ?>
													</span>
												<?php endif; ?>
											</span>
										</td>
										<td class="column-actions">
											<?php if ( $is_hard_disabled ) : ?>
												<div class="hellopack-module-hard-disabled">
													<span style="color: #6c757d; font-size: 12px; font-style: italic;">
														<?php _e( 'Locked by configuration', 'hellopack-client' ); ?>
													</span>
												</div>
											<?php else : ?>
												<div class="hellopack-module-toggle-wrapper">
													<div class="hellopack-form-radio-button-set ui-buttonset">
														<input type="hidden" class="module-toggle-value" 
															value="<?php echo $is_enabled ? 'on' : 'off'; ?>" 
															data-module-id="<?php echo esc_attr( $module_id ); ?>">
														<a data-value="on" class="ui-button buttonset-item <?php echo $is_enabled ? 'ui-state-active' : ''; ?>" 
															href="#" data-module-id="<?php echo esc_attr( $module_id ); ?>">
															<?php esc_html_e( 'On', 'hellopack-client' ); ?>
														</a>
														<a data-value="off" class="ui-button buttonset-item <?php echo !$is_enabled ? 'ui-state-active' : ''; ?>" 
															href="#" data-module-id="<?php echo esc_attr( $module_id ); ?>">
															<?php esc_html_e( 'Off', 'hellopack-client' ); ?>
														</a>
													</div>
												</div>
											<?php endif; ?>
										</td>
									</tr>
								<?php endforeach; ?>
							</tbody>
						</table>
				</div>
			<?php endforeach; ?>
		</div>
	<?php endif; ?>
	
	<div class="hellopack-builder-important-notice hellopack-template-builder hellopack-db-card">
		<div class="hellopack-modules-info">
			<h3><?php _e( 'Module Status Guide', 'hellopack-client' ); ?></h3>
			<div class="hellopack-status-guide">
				<div class="status-item">
					<span class="status-indicator status-active">●</span>
					<div>
						<strong><?php _e( 'Active', 'hellopack-client' ); ?></strong><br>
						<?php _e( 'Module is enabled and currently running', 'hellopack-client' ); ?>
					</div>
				</div>
				<div class="status-item">
					<span class="status-indicator status-disabled">●</span>
					<div>
						<strong><?php _e( 'Disabled', 'hellopack-client' ); ?></strong><br>
						<?php _e( 'Module is manually disabled', 'hellopack-client' ); ?>
					</div>
				</div>
				<div class="status-item">
					<span class="status-indicator status-hard-disabled">●</span>
					<div>
						<strong><?php _e( 'Hard-disabled', 'hellopack-client' ); ?></strong><br>
						<?php _e( 'Module is disabled via HP_DISABLE_PLUGINS configuration', 'hellopack-client' ); ?>
					</div>
				</div>
			</div>
			<p class="description"><?php _e( 'Modules are only displayed when their target plugin or theme is active on your site.', 'hellopack-client' ); ?></p>
		</div>
	</div>
</div>

<style>
/* Module panel styling to match HelloPack design */

.hellopack-modules-info {
	padding: 20px;
}

.hellopack-modules-info h3 {
	margin-top: 0;
	margin-bottom: 15px;
	font-size: 1.2em;
	color: #23282d;
}

.hellopack-status-guide {
	display: grid;
	grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
	gap: 15px;
	margin-bottom: 20px;
}

.status-item {
	display: flex;
	align-items: flex-start;
	padding: 10px;
	background: #f8f9fa;
	border-radius: 5px;
}

.status-indicator {
	font-size: 1.2em;
	margin-right: 10px;
}

.hellopack-module-category-title {
	font-size: 1.3em;
	margin: 0 0 20px;
	padding: 15px 20px 10px 20px;
}

.hellopack-module-count {
	color: #666;
	font-weight: normal;
	font-size: 0.85em;
}

.hellopack-modules-table {
	border: none !important;
	box-shadow: none !important;
	margin: 0;
}

.hellopack-modules-table td,
.hellopack-modules-table th {
	border: none !important;
}

.hellopack-modules-table thead th {
	background: #fff;
	border-bottom: 2px solid #e5e5e5 !important;
	color: #666;
	font-weight: 600;
	text-transform: uppercase;
	font-size: 11px;
	letter-spacing: 0.5px;
}

.hellopack-modules-table tbody tr {
	border-bottom: 1px solid #f1f1f1 !important;
}

.hellopack-modules-table tbody tr:hover {
	background: #f9f9f9;
}

.hellopack-modules-table .column-name strong {
	font-size: 14px;
	color: #23282d;
}

.hellopack-modules-table .description {
	font-size: 13px;
	color: #666;
	margin-top: 3px;
}

.column-target {
	width: 25%;
	color: #555;
	vertical-align: middle !important;
}

.column-status {
	width: 15%;
	vertical-align: middle !important;
}

.hellopack-modules-table tbody tr td {
	vertical-align: middle;
}

.column-actions {
	width: 15%;
	text-align: right;
	vertical-align: middle !important;
}

.status-active {
	color: #46b450;
	font-weight: 600;
}

.status-disabled {
	color: #dc3232;
	font-weight: 600;
}

.status-ready {
	color: #198fd9;
	font-weight: 600;
}

.hellopack-modules-table .button {
	padding: 4px 12px;
	height: auto;
	line-height: 1.4;
	font-size: 13px;
	border-radius: 3px;
	transition: all 0.2s ease;
}

.hellopack-modules-table .button:hover {
	transform: translateY(-1px);
	box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

/* Ensure proper spacing in columns layout */
.hellopack-client-columns .hellopack-db-card {
	margin-bottom: 20px;
}

/* Notice styling */
.hellopack-notice {
	margin: 20px 0;
}

/* Responsive adjustments */
@media screen and (max-width: 782px) {
	.hellopack-status-guide {
		grid-template-columns: 1fr;
	}
	
	.column-target,
	.column-status {
		display: none;
	}
	
	.column-actions {
		width: auto;
		text-align: left;
	}
}
</style>

<script>
var hellopack_modules = {
	nonce: '<?php echo wp_create_nonce( 'hellopack_modules_nonce' ); ?>',
	enable_text: '<?php _e( 'Enable', 'hellopack-client' ); ?>',
	disable_text: '<?php _e( 'Disable', 'hellopack-client' ); ?>',
	active_text: '<?php _e( 'Active', 'hellopack-client' ); ?>',
	ready_text: '<?php _e( 'Ready', 'hellopack-client' ); ?>',
	disabled_text: '<?php _e( 'Disabled', 'hellopack-client' ); ?>',
	error_text: '<?php _e( 'An error occurred. Please try again.', 'hellopack-client' ); ?>'
};
</script>