<?php
/**
 * Advanced Custom Fields Pro Module
 *
 * @package HelloPack_Client
 * @since 2.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * ACF Pro module class.
 */
class HelloPack_Module_ACF_Pro extends HelloPack_Module_Base {

	/**
	 * Setup module properties
	 */
	protected function setup() {
		$this->id          = 'acf-pro';
		$this->name        = __( 'Advanced Custom Fields Pro', 'hellopack-client' );
		$this->description = __( 'Manages Advanced Custom Fields Pro updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'advanced-custom-fields-pro',
			'plugin_file' => 'acf.php',
		);
	}

	/**
	 * Initialize the module
	 */
	public function init() {
		// Hide ACF admin notices
		$this->hide_admin_notices();
		
		// Set license status
		$this->set_license_status();
		
		// Set license key
		$this->set_license_key();
		
		// Override API servers
		$this->override_api_servers();
	}

	/**
	 * Hide ACF admin notices
	 */
	private function hide_admin_notices() {
		if ( class_exists( 'HelloPackCSSDisable' ) ) {
			$acf_notice = new HelloPackCSSDisable();
			$acf_notice->add_selector( '.acf-admin-notice' );
			$acf_notice->hide_notices();
		}
	}

	/**
	 * Set ACF Pro license status
	 */
	private function set_license_status() {
		$data = array(
			'status'                  => 'active',
			'created'                 => 1757743171,
			'expiry'                  => 1847743171,
			'name'                    => 'PRO',
			'lifetime'                => false,
			'refunded'                => false,
			'view_licenses_url'       => 'https://www.advancedcustomfields.com/my-account/view-licenses/',
			'manage_subscription_url' => 'https://www.advancedcustomfields.com/my-account/view-subscription/13452/',
			'error_msg'               => '',
			'next_check'              => 1907743171,
			'legacy_multisite'        => true,
		);

		if ( function_exists( 'HP_check_options' ) ) {
			HP_check_options( 'acf_pro_license_status', $data );
		}
	}

	/**
	 * Set ACF Pro license key
	 */
	private function set_license_key() {
		$acf_pro_license = array(
			'key' => 'c2d33db6-ff4d-4c49-b2f7-c42f49242f42',
			'url' => get_home_url(),
		);

		$acf_pro_license = base64_encode( maybe_serialize( $acf_pro_license ) );

		if ( function_exists( 'HP_check_options' ) ) {
			HP_check_options( 'acf_pro_license', $acf_pro_license );
		}
	}

	/**
	 * Override API servers
	 */
	private function override_api_servers() {
		if ( class_exists( 'HPack_Set_API_Servers' ) ) {
			$advancedcustomfields = new HPack_Set_API_Servers();
			$advancedcustomfields->over_api_servers( 'connect.advancedcustomfields.com/v2/plugins/update-check' );
			$advancedcustomfields->init();
		}
	}
}