<?php
/**
 * Admin Menu Editor Pro Module
 *
 * @package HelloPack_Client
 * @since 2.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Admin Menu Editor Pro module class.
 */
class HelloPack_Module_Admin_Menu_Editor_Pro extends HelloPack_Module_Base {

	/**
	 * Setup module properties
	 */
	protected function setup() {
		$this->id          = 'admin-menu-editor-pro';
		$this->name        = __( 'Admin Menu Editor Pro', 'hellopack-client' );
		$this->description = __( 'Manages Admin Menu Editor Pro updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'admin-menu-editor-pro',
			'plugin_file' => 'menu-editor.php',
		);
	}

	/**
	 * Initialize the module
	 */
	public function init() {
		// Setup API servers for licensing
		$this->setup_api_servers();
		
		// Disable upgrader pre-download
		add_action( 'admin_init', 'disable_upgrader_pre_download' );
	}

	/**
	 * Setup API servers for Admin Menu Editor Pro
	 */
	private function setup_api_servers() {
		if ( class_exists( 'HPack_Set_API_Servers' ) ) {
			// License API server
			$admin_menu_editor_pro = new HPack_Set_API_Servers();
			$admin_menu_editor_pro->set_api_servers( 
				'/adminmenueditor.com/licensing_api/products/admin-menu-editor-pro/licenses', 
				HELLOPACK_LICENSE_MANAGER_SERVER . '/admin-menu-editor-pro/licenses/?s=' 
			);
			$admin_menu_editor_pro->init();

			// Main domain API server
			$adminmenueditor = new HPack_Set_API_Servers();
			$adminmenueditor->set_api_servers( 
				'adminmenueditor.com', 
				HELLOPACK_LICENSE_MANAGER_SERVER . '/admin-menu-editor-pro/licenses/?s=' 
			);
			$adminmenueditor->init();
		}
	}
}