<?php
/**
 * AffiliateWP Module
 *
 * @package HelloPack_Client
 * @since 2.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * AffiliateWP module class.
 */
class HelloPack_Module_Affiliate_WP extends HelloPack_Module_Base {

	/**
	 * Setup module properties
	 */
	protected function setup() {
		$this->id          = 'affiliate-wp';
		$this->name        = __( 'AffiliateWP', 'hellopack-client' );
		$this->description = __( 'Manages AffiliateWP updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'affiliate-wp',
			'plugin_file' => 'affiliate-wp.php',
		);
	}

	/**
	 * Initialize the module
	 */
	public function init() {
		// Override notifications API
		$this->override_notifications_api();
		
		// Setup license immediately if plugin is loaded
		if ( function_exists( 'affiliate_wp' ) ) {
			$this->setup_license();
		} else {
			// Otherwise wait for plugins_loaded
			add_action( 'plugins_loaded', array( $this, 'setup_license' ), 20 );
		}
	}

	/**
	 * Override AffiliateWP notifications API
	 */
	private function override_notifications_api() {
		if ( class_exists( 'HPack_Set_API_Servers' ) ) {
			$affiliate_wp = new HPack_Set_API_Servers();
			$affiliate_wp->over_api_servers( 'plugin.affiliatewp.com/wp-content/notifications.json' );
			$affiliate_wp->init();
		}
	}

	/**
	 * Setup AffiliateWP license
	 */
	public function setup_license() {
		if ( ! function_exists( 'affiliate_wp' ) ) {
			return;
		}

		$settings = affiliate_wp()->settings;

		$license_data = (object) array(
			'price_id' => 3,
			'license'  => 'valid',
			'success'  => true,
		);

		$settings->set(
			array(
				'license_status' => $license_data,
				'license_key'    => HP_GLOBAL_SERIAL,
			),
			true
		);

		// Set license check transient
		set_transient( 'affwp_license_check', 'valid', DAY_IN_SECONDS );

		// Update failed request cache
		$failed_request_cache_key = 'edd_sl_failed_http_' . md5( 'https://affiliatewp.com' );
		update_option( $failed_request_cache_key, strtotime( '+24 hours' ) );
	}
}