<?php
/**
 * All-in-One WP Migration Module
 *
 * @package HelloPack_Client
 * @since 2.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * All-in-One WP Migration module class.
 */
class HelloPack_Module_All_In_One_Migration extends HelloPack_Module_Base {

	/**
	 * Setup module properties
	 */
	protected function setup() {
		$this->id          = 'all-in-one-migration';
		$this->name        = __( 'All-in-One WP Migration', 'hellopack-client' );
		$this->description = __( 'Manages All-in-One WP Migration updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'all-in-one-wp-migration',
			'plugin_file' => 'all-in-one-wp-migration.php',
		);
	}

	/**
	 * Initialize the module
	 */
	public function init() {
		// Delete updater option
		delete_option( 'ai1wm_updater' );
		
		// Override update check API
		$this->override_update_api();
	}

	/**
	 * Override All-in-One WP Migration update check API
	 */
	private function override_update_api() {
		if ( class_exists( 'HPack_Set_API_Servers' ) ) {
			$all_in_one_wp_migration = new HPack_Set_API_Servers();
			$all_in_one_wp_migration->over_api_servers( 'https://redirect.wp-migration.com/v1/check/unlimited-extension/' );
			$all_in_one_wp_migration->init();
		}
	}
}