<?php
/**
 * AutomatorWP Pro Module
 *
 * @package HelloPack_Client
 * @since 2.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * AutomatorWP Pro module class.
 */
class HelloPack_Module_AutomatorWP_Pro extends HelloPack_Module_Base {

	/**
	 * Setup module properties
	 */
	protected function setup() {
		$this->id          = 'automatorwp-pro';
		$this->name        = __( 'AutomatorWP Pro', 'hellopack-client' );
		$this->description = __( 'Manages AutomatorWP Pro updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'automatorwp-pro',
			'plugin_file' => 'automatorwp-pro.php',
		);
	}

	/**
	 * Initialize the module
	 */
	public function init() {
		// Hide update notices
		$this->hide_update_notices();
		
		// Remove unnecessary admin menu items
		add_action( 'admin_menu', array( $this, 'remove_admin_menu_items' ), 999 );
		
		// Set API servers
		$automatorwp = new HPack_Set_API_Servers();
		$automatorwp->over_api_servers( 'automatorwp.com/edd-sl-api' );
		$automatorwp->init();
	}

	/**
	 * Hide AutomatorWP Pro update notices
	 */
	private function hide_update_notices() {
		if ( class_exists( 'HelloPackCSSDisable' ) ) {
			$automatorwp = new HelloPackCSSDisable();
			$automatorwp->add_selector( '#automatorwp-pro-update strong' );
			$automatorwp->hide_notices();
		}
	}

	/**
	 * Remove add-ons and licenses menu items
	 */
	public function remove_admin_menu_items() {
		remove_submenu_page( 'automatorwp', 'automatorwp_add_ons' );
		remove_submenu_page( 'automatorwp', 'automatorwp_licenses' );
	}
}