<?php
/**
 * Booster Plus for WooCommerce Module
 *
 * @package HelloPack_Client
 * @since 2.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Booster Plus for WooCommerce module class.
 */
class HelloPack_Module_Booster_Plus_For_WooCommerce extends HelloPack_Module_Base {

	/**
	 * Setup module properties
	 */
	protected function setup() {
		$this->id          = 'booster-plus-for-woocommerce';
		$this->name        = __( 'Booster Plus for WooCommerce', 'hellopack-client' );
		$this->description = __( 'Manages Booster Plus for WooCommerce updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'booster-plus-for-woocommerce',
			'plugin_file' => 'booster-plus-for-woocommerce.php',
		);
	}

	/**
	 * Initialize the module
	 */
	public function init() {
		// Setup API servers
		$this->setup_api_servers();
		
		// Set license key
		$this->set_license_key();
	}

	/**
	 * Setup API servers for Booster Plus
	 */
	private function setup_api_servers() {
		if ( class_exists( 'HPack_Set_API_Servers' ) ) {
			$booster_plus = new HPack_Set_API_Servers();
			$booster_plus->set_api_servers( 
				'booster.io/?check_site_key=', 
				HELLOPACK_LICENSE_MANAGER_SERVER . '/booster-plus-for-woocommerce/activate-license?s=' 
			);
			$booster_plus->init();
		}
	}

	/**
	 * Set Booster Plus license key
	 */
	private function set_license_key() {
		// Clear site key status
		if ( function_exists( 'HP_check_options' ) ) {
			HP_check_options( 'wcj_site_key_status', '' );
			HP_check_options( 'wcj_site_key', 'AWHD-1234-EFGH-5678-IJKL-9012' );
		} else {
			update_option( 'wcj_site_key_status', '' );
			update_option( 'wcj_site_key', 'AWHD-1234-EFGH-5678-IJKL-9012' );
		}
	}
}