<?php
/**
 * HelloPack Module: Bricks
 *
 * @package HelloPack
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Class HelloPack_Module_Bricks
 *
 * Module for managing Bricks theme functionality
 */
class HelloPack_Module_Bricks extends HelloPack_Module_Base {

	/**
	 * Module setup
	 *
	 * @return void
	 */
	public function setup() {
		$this->id          = 'bricks';
		$this->name        = 'Bricks';
		$this->description = __( 'Manages Bricks theme updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'theme';
		$this->version     = '1.0.0';
		$this->target      = array(
			'theme_slug' => 'bricks',
		);
	}

	/**
	 * Module initialization
	 *
	 * @return void
	 */
	public function init() {
		if ( ! hp_is_theme_activated( 'bricks' ) ) {
			return;
		}

		HP_check_options( 'bricks_license_key', 'AWHD-1234-EFGH-5678-IJKL-9012' );

		$license_status = array(
			'status' => 'active',
		);
		$expiration_time = 10000 * 168 * HOUR_IN_SECONDS;

		set_transient( 'bricks_license_status', $license_status, $expiration_time );

		$bricks = new HPack_Set_API_Servers();
		$bricks->set_api_servers( 'bricksbuilder.io/api/commerce/license/', HELLOPACK_LICENSE_MANAGER_SERVER . '/bricks/activate-license?s=' );
		$bricks->init();
	}
}