<?php
/**
 * CartFlows Pro Module
 *
 * @package HelloPack_Client
 * @since 2.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * CartFlows Pro module class.
 */
class HelloPack_Module_CartFlows_Pro extends HelloPack_Module_Base {

	/**
	 * Setup module properties
	 */
	protected function setup() {
		$this->id          = 'cartflows-pro';
		$this->name        = __( 'CartFlows Pro', 'hellopack-client' );
		$this->description = __( 'Manages CartFlows Pro updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'cartflows-pro',
			'plugin_file' => 'cartflows-pro.php',
		);
	}

	/**
	 * Initialize the module
	 */
	public function init() {
		// Setup API servers
		$this->setup_api_servers();
		
		// Setup license options
		$this->setup_license_options();
		
		// Block update APIs
		$this->block_update_apis();
	}

	/**
	 * Setup API servers for CartFlows
	 */
	private function setup_api_servers() {
		if ( class_exists( 'HPack_Set_API_Servers' ) ) {
			// Templates API
			$cartflows = new HPack_Set_API_Servers();
			$cartflows->set_api_servers( 
				'templates.cartflows.com', 
				'api-register.wp-json.app/cartflow/?rout=' 
			);
			$cartflows->init();

			// Registry API
			$cartflows_registry = new HPack_Set_API_Servers();
			$cartflows_registry->set_api_servers( 
				'my.cartflows.com/?wc-api=am-software-api', 
				'api-register.wp-json.app/cartflow/registry?rout=' 
			);
			$cartflows_registry->init();
		}
	}

	/**
	 * Setup CartFlows license options
	 */
	private function setup_license_options() {
		// WC AM Client options
		$wc_am_client_cartflows = get_option( 'wc_am_client_cartflows' );
		$expected_value = array( 'wc_am_client_cartflows_api_key' => HP_GLOBAL_SERIAL );
		
		if ( false === $wc_am_client_cartflows || $wc_am_client_cartflows !== $expected_value ) {
			update_option( 'wc_am_client_cartflows', $expected_value );
		}

		// WC AM Client API Key
		$wc_am_client_cartflows_api_key = get_option( 'wc_am_client_cartflows_api_key' );
		$expected_api_key = array( 'api_key' => HP_GLOBAL_SERIAL );
		
		if ( false === $wc_am_client_cartflows_api_key || $wc_am_client_cartflows_api_key !== $expected_api_key ) {
			update_option( 'wc_am_client_cartflows_api_key', $expected_api_key );
		}

		// License options
		$options = array(
			'_cfw_licensing__license_key'      => HP_GLOBAL_SERIAL,
			'_cfw_licensing__key_status'       => 'valid',
			'cfw_license_activation_limit'     => 500,
			'cfw_license_price_id'             => 9,
			'wc_am_client_cartflows_activated' => 'Activated',
		);

		foreach ( $options as $option_name => $option_value ) {
			$current_value = get_option( $option_name );
			if ( false === $current_value || $current_value !== $option_value ) {
				update_option( $option_name, $option_value );
			}
		}

		// Backup data
		$backup_data = array(
			'wc_am_client_cartflows_api_key' => array( 'api_key' => HP_GLOBAL_SERIAL ),
			'wc_am_client_cartflows'         => array( 'wc_am_client_cartflows_api_key' => HP_GLOBAL_SERIAL ),
		);
		
		$current_backup = get_option( 'cartflows_license_backup_data' );
		if ( false === $current_backup || $current_backup !== $backup_data ) {
			update_option( 'cartflows_license_backup_data', $backup_data );
		}
	}

	/**
	 * Block CartFlows update APIs
	 */
	private function block_update_apis() {
		if ( class_exists( 'HPack_Block_API_Servers' ) ) {
			// Block CartFlows update API
			$cartflows_block = new HPack_Block_API_Servers();
			$cartflows_block->set_api_servers( 'my.cartflows.com/?wc-api=wc-am-api&request=update&slug=cartflows-pro&plugin_name=cartflows-pro' );
			$cartflows_block->init();

			// Block TMS plugins API
			$tmsplugins_block = new HPack_Block_API_Servers();
			$tmsplugins_block->set_api_servers( 'store.tms-plugins.com/api/autoupdate/info' );
			$tmsplugins_block->init();
		}
	}
}