<?php
/**
 * CheckoutWC Module
 *
 * @package HelloPack_Client
 * @since 2.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * CheckoutWC module class.
 */
class HelloPack_Module_CheckoutWC extends HelloPack_Module_Base {

	/**
	 * Setup module properties
	 */
	protected function setup() {
		$this->id          = 'checkoutwc';
		$this->name        = __( 'Checkout for WooCommerce', 'hellopack-client' );
		$this->description = __( 'Manages Checkout for WooCommerce updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'checkout-for-woocommerce',
			'plugin_file' => 'checkout-for-woocommerce.php',
		);
	}

	/**
	 * Initialize the module
	 */
	public function init() {
		// Setup license options
		$this->setup_license_options();
		
		// Setup API servers
		$this->setup_api_servers();
	}

	/**
	 * Setup CheckoutWC license options
	 */
	private function setup_license_options() {
		// Update license status and key
		update_option( '_cfw_licensing__key_status', 'valid', 'yes' );
		update_option( '_cfw_licensing__license_key', HP_GLOBAL_SERIAL, 'yes' );
		update_option( 'cfw_license_activation_limit', '500', 'yes' );
		update_option( 'cfw_license_price_id', '10' );

		// Setup license data
		$license_data = (object) array(
			'customer_name'  => get_bloginfo( 'name' ),
			'customer_email' => get_bloginfo( 'admin_email' ),
		);
		update_option( 'cfw_license_data', $license_data );
	}

	/**
	 * Setup API servers for CheckoutWC
	 */
	private function setup_api_servers() {
		if ( class_exists( 'HPack_Set_API_Servers' ) ) {
			// License check API
			$fw_licensing = new HPack_Set_API_Servers();
			$fw_licensing->set_api_servers( 
				'www.checkoutwc.com/?edd_action=check_license&license=', 
				HELLOPACK_LICENSE_MANAGER_SERVER . '/checkoutwc/activate-license?s=' 
			);
			$fw_licensing->init();

			// License deactivation API
			$fw_licensing_deactivate = new HPack_Set_API_Servers();
			$fw_licensing_deactivate->set_api_servers( 
				'www.checkoutwc.com/?edd_action=deactivate_license&license=', 
				HELLOPACK_LICENSE_MANAGER_SERVER . '/checkoutwc/activate-license?s=' 
			);
			$fw_licensing_deactivate->init();
		}
	}
}