<?php
/**
 * Crocoblock Module
 *
 * @package HelloPack
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Class HelloPack_Module_Crocoblock
 */
class HelloPack_Module_Crocoblock extends HelloPack_Module_Base {

	/**
	 * Set up the module properties.
	 */
	protected function setup() {
		$this->id          = 'crocoblock';
		$this->name        = 'Crocoblock';
		$this->description = __( 'Manages Crocoblock updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'jet-engine',
			'plugin_file' => 'jet-engine.php',
		);
	}

	/**
	 * Initialize the module functionality.
	 */
	public function init() {
		if ( ! $this->should_load() ) {
			return;
		}

		$this->set_crocoblock_api_servers();
	}

	/**
	 * Set Crocoblock API servers.
	 */
	private function set_crocoblock_api_servers() {
		if ( class_exists( 'HPack_Set_API_Servers' ) ) {
			$crocoblock = new HPack_Set_API_Servers();
			$crocoblock->set_api_servers( 'api.crocoblock.com', HP_PLUGIN_API_SERVER . '/crocoblock' );
			$crocoblock->init();
		}
	}
}