<?php
/**
 * Divi Responsive Helper Module
 *
 * @package HelloPack
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Class HelloPack_Module_Divi_Responsive_Helper
 */
class HelloPack_Module_Divi_Responsive_Helper extends HelloPack_Module_Base {

	/**
	 * Set up the module properties.
	 */
	protected function setup() {
		$this->id          = 'divi-responsive-helper';
		$this->name        = 'Divi Responsive Helper';
		$this->description = __( 'Manages Divi Responsive Helper updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'divi-responsive-helper',
			'plugin_file' => 'divi-responsive-helper.php',
		);
	}

	/**
	 * Initialize the module functionality.
	 */
	public function init() {
		if ( ! $this->should_load() ) {
			return;
		}

		$this->set_api_servers();
		add_action( 'admin_init', array( $this, 'disable_upgrader_pre_download' ) );
	}

	/**
	 * Set API servers for Divi Responsive Helper.
	 */
	private function set_api_servers() {
		if ( class_exists( 'HPack_Set_API_Servers' ) ) {
			$divi_helper = new HPack_Set_API_Servers();
			$divi_helper->over_api_servers( 'www.peeayecreative.com/product/divi-responsive-helper' );
			$divi_helper->init();
		}
	}

	/**
	 * Disable upgrader pre-download.
	 */
	public function disable_upgrader_pre_download() {
		// Implementation needed if the function exists elsewhere
		if ( function_exists( 'disable_upgrader_pre_download' ) ) {
			disable_upgrader_pre_download();
		}
	}
}