<?php
/**
 * Dynamic Content for Elementor Module
 *
 * @package HelloPack_Client
 * @since 2.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Dynamic Content for Elementor module class.
 */
class HelloPack_Module_Dynamic_Content_For_Elementor extends HelloPack_Module_Base {

	/**
	 * Setup module properties
	 */
	protected function setup() {
		$this->id          = 'dynamic-content-for-elementor';
		$this->name        = __( 'Dynamic Content for Elementor', 'hellopack-client' );
		$this->description = __( 'Manages Dynamic Content for Elementor updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'dynamic-content-for-elementor',
			'plugin_file' => 'dynamic-content-for-elementor.php',
		);
	}

	/**
	 * Initialize the module
	 */
	public function init() {
		// Clear license error
		delete_option( 'dce_license_error' );
		
		// Set license as activated
		$this->set_license_active();
		
		// Override license API
		$this->override_license_api();
		
		// Disable upgrader pre-download
		add_action( 'admin_init', 'disable_upgrader_pre_download' );
	}

	/**
	 * Set Dynamic Content for Elementor license as active
	 */
	private function set_license_active() {
		if ( function_exists( 'HP_check_options' ) ) {
			HP_check_options( 'dce_license_activated', 1 );
			HP_check_options( 'dce_license_status', 'active' );
		} else {
			update_option( 'dce_license_activated', 1 );
			update_option( 'dce_license_status', 'active' );
		}
	}

	/**
	 * Override Dynamic Content for Elementor license API
	 */
	private function override_license_api() {
		if ( class_exists( 'HPack_Set_API_Servers' ) ) {
			$dynamic = new HPack_Set_API_Servers();
			$dynamic->over_api_servers( 'license.dynamic.ooo' );
			$dynamic->init();
		}
	}
}