<?php
/**
 * Fluent CRM Module
 *
 * @package HelloPack
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Class HelloPack_Module_Fluent_CRM
 */
class HelloPack_Module_Fluent_CRM extends HelloPack_Module_Base {

	/**
	 * Set up the module properties.
	 */
	protected function setup() {
		$this->id          = 'fluent-crm';
		$this->name        = 'Fluent CRM';
		$this->description = __( 'Manages Fluent CRM updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'fluentcampaign-pro',
			'plugin_file' => 'fluentcampaign-pro.php',
		);
	}

	/**
	 * Initialize the module functionality.
	 */
	public function init() {
		if ( ! $this->should_load() ) {
			return;
		}

		$this->activate_license();
	}

	/**
	 * Activate FluentCampaign Pro license.
	 */
	private function activate_license() {
		$license_data = array(
			'license_key' => HP_GLOBAL_SERIAL,
			'price_id'    => '',
			'expires'     => date( 'Y-m-d H:i:s', strtotime( '+1 year' ) ),
			'status'      => 'valid',
		);

		HP_check_options( '__fluentcrm_campaign_license', $license_data );
	}
}