<?php
/**
 * Fluent Support Pro Module
 *
 * @package HelloPack
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Class HelloPack_Module_Fluent_Support_Pro
 */
class HelloPack_Module_Fluent_Support_Pro extends HelloPack_Module_Base {

	/**
	 * Set up the module properties.
	 */
	protected function setup() {
		$this->id          = 'fluent-support-pro';
		$this->name        = 'Fluent Support Pro';
		$this->description = __( 'Manages Fluent Support Pro updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'fluent-support-pro',
			'plugin_file' => 'fluent-support-pro.php',
		);
	}

	/**
	 * Initialize the module functionality.
	 */
	public function init() {
		if ( ! $this->should_load() ) {
			return;
		}

		$this->activate_license();
	}

	/**
	 * Activate Fluent Support Pro license.
	 */
	private function activate_license() {
		$license_data = array(
			'license_key' => HP_GLOBAL_SERIAL,
			'price_id'    => '',
			'expires'     => date( 'Y-m-d H:i:s', strtotime( '+1 year' ) ),
			'status'      => 'valid',
		);

		HP_check_options( '__fluentsupport_pro_license', $license_data );
	}
}