<?php
/**
 * FluentCampaign Pro Module
 *
 * @package HelloPack_Client
 * @since 2.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * FluentCampaign Pro module class.
 */
class HelloPack_Module_FluentCampaign_Pro extends HelloPack_Module_Base {

	/**
	 * Setup module properties
	 */
	protected function setup() {
		$this->id          = 'fluentcampaign-pro';
		$this->name        = __( 'FluentCampaign Pro', 'hellopack-client' );
		$this->description = __( 'Manages FluentCampaign Pro updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'fluentcampaign-pro',
			'plugin_file' => 'fluentcampaign-pro.php',
		);
	}

	/**
	 * Initialize the module
	 */
	public function init() {
		// Set API servers
		$fluentcampaign = new HPack_Set_API_Servers();
		$fluentcampaign->over_api_servers( 'apiv2.wpmanageninja.com/plugin' );
		$fluentcampaign->init();
	}
}