<?php
/**
 * FluentForm Pro Module
 *
 * @package HelloPack
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Class HelloPack_Module_FluentForm_Pro
 */
class HelloPack_Module_FluentForm_Pro extends HelloPack_Module_Base {

	/**
	 * Set up the module properties.
	 */
	protected function setup() {
		$this->id          = 'fluentformpro';
		$this->name        = 'FluentForm Pro';
		$this->description = __( 'Manages FluentForm Pro updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'fluentformpro',
			'plugin_file' => 'fluentformpro.php',
		);
	}

	/**
	 * Initialize the module functionality.
	 */
	public function init() {
		if ( ! $this->should_load() ) {
			return;
		}

		$this->activate_license();
	}

	/**
	 * Activate FluentForm Pro license.
	 */
	private function activate_license() {
		HP_check_options( '_ff_fluentform_pro_license_key', HP_GLOBAL_SERIAL );
		HP_check_options( '_ff_fluentform_pro_license_status', 'valid' );

		delete_option( '_ff_fluentform_pro_license_key' );
		delete_option( '_ff_fluentform_pro_license_status_checking' );
	}
}