<?php
/**
 * Gravity Forms Module
 *
 * @package HelloPack
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Class HelloPack_Module_Gravityforms
 */
class HelloPack_Module_Gravityforms extends HelloPack_Module_Base {

	/**
	 * Set up the module properties.
	 */
	protected function setup() {
		$this->id          = 'gravityforms';
		$this->name        = 'Gravity Forms';
		$this->description = __( 'Manages Gravity Forms updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'gravityforms',
			'plugin_file' => 'gravityforms.php',
		);
	}

	/**
	 * Initialize the module functionality.
	 */
	public function init() {
		if ( ! $this->should_load() ) {
			return;
		}

		$this->activate_license();
	}

	/**
	 * Activate Gravity Forms license.
	 */
	private function activate_license() {
		$gform_installation_wizard_license_key = array(
			'license_key'  => 'ea247f6f2342a58670ad96bf98781ebc',
			'accept_terms' => true,
			'is_valid_key' => true,
		);

		HP_check_options( 'rg_gforms_key', '6a3b2efaf5c7063ca00785b46d90dcd2' );
		HP_check_options( 'gform_installation_wizard_license_key', $gform_installation_wizard_license_key );
	}
}