<?php
/**
 * JetHelloPack Module
 *
 * @package HelloPack
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Class HelloPack_Module_JetHelloPack
 */
class HelloPack_Module_JetHelloPack extends HelloPack_Module_Base {

	/**
	 * Set up the module properties.
	 */
	protected function setup() {
		$this->id          = 'jet-hellopack';
		$this->name        = 'JetHelloPack';
		$this->description = __( 'Manages JetHelloPack updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'jet-a-hellopack',
			'plugin_file' => 'jet-a-hellopack.php',
		);
	}

	/**
	 * Initialize the module functionality.
	 */
	public function init() {
		if ( ! $this->should_load() ) {
			return;
		}

		add_action( 'admin_notices', array( $this, 'show_deprecation_notice' ) );
	}

	/**
	 * Show deprecation notice for JetHelloPack.
	 */
	public function show_deprecation_notice() {
		?>
		<div class="notice notice-warning" style="background-color: #fffcee">
			<p><?php _e( 'The <strong>JetHelloPack</strong> plugin is active on your site, but it is no longer needed. You can safely deactivate and delete it.', 'hellopack-client' ); ?>
			</p>
		</div>
		<?php
	}
}