<?php
/**
 * JetFormBuilder Module
 *
 * @package HelloPack
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Class HelloPack_Module_JetFormBuilder
 */
class HelloPack_Module_JetFormBuilder extends HelloPack_Module_Base {

	/**
	 * Set up the module properties.
	 */
	protected function setup() {
		$this->id          = 'jetformbuilder';
		$this->name        = 'JetFormBuilder';
		$this->description = __( 'Manages JetFormBuilder updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'jetformbuilder',
			'plugin_file' => 'jet-form-builder.php',
		);
	}

	/**
	 * Initialize the module functionality.
	 */
	public function init() {
		if ( ! $this->should_load() ) {
			return;
		}

		$this->activate_license();
		$this->set_api_servers();
	}

	/**
	 * Activate JetFormBuilder license.
	 */
	private function activate_license() {
		$jet_data = array(
			array(
				'success'                     => true,
				'license'                     => 'valid',
				'item_id'                     => 9,
				'item_name'                   => 'PRO Form Builder Addons Subscription',
				'is_local'                    => true,
				'license_limit'               => 0,
				'site_count'                  => 1,
				'expires'                     => 'lifetime',
				'activations_left'            => 'unlimited',
				'checksum'                    => '8b2b7e4e7f432ee47efb6d4d7c3bfe2a',
				'payment_id'                  => 4241,
				'customer_name'               => 'HelloWP Support',
				'customer_email'              => 'support@hellowp.io',
				'price_id'                    => '3',
				'excluded_plugins'            => array(),
				'has_templates_access'        => false,
				'has_design_templates_access' => false,
				'license_key'                 => HP_GLOBAL_SERIAL,
			),
		);

		HP_check_options( 'jfb-license-data', $jet_data );
	}

	/**
	 * Set API servers for JetFormBuilder.
	 */
	private function set_api_servers() {
		if ( class_exists( 'HPack_Set_API_Servers' ) ) {
			$jetformbuilder_updates_support = new HPack_Set_API_Servers();
			$jetformbuilder_updates_support->set_api_servers( 'account.jetformbuilder.com?edd_action=activate_license', HELLOPACK_LICENSE_MANAGER_SERVER . '/jetformbuilder/license-activation?s=' );
			$jetformbuilder_updates_support->init();

			$jetformbuilder_download = new HPack_Set_API_Servers();
			$jetformbuilder_download->set_api_servers( 'account.jetformbuilder.com?ct_api_action=get_plugin&', HELLOPACK_LICENSE_MANAGER_SERVER . '/jetformbuilder/download?domain=' . HP_GLOBAL_URL . '&' );
			$jetformbuilder_download->init();
		}
	}
}