<?php
/**
 * JS Composer (WPBakery Page Builder) Module
 *
 * @package HelloPack
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Class HelloPack_Module_JS_Composer
 */
class HelloPack_Module_JS_Composer extends HelloPack_Module_Base {

	/**
	 * Set up the module properties.
	 */
	protected function setup() {
		$this->id          = 'js-composer';
		$this->name        = 'JS Composer';
		$this->description = __( 'Manages JS Composer updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'js_composer',
			'plugin_file' => 'js_composer.php',
		);
	}

	/**
	 * Initialize the module functionality.
	 */
	public function init() {
		if ( ! $this->should_load() ) {
			return;
		}

		$this->set_api_servers();
		$this->activate_license();
		add_action( 'admin_init', array( $this, 'disable_upgrader_pre_download' ) );
	}

	/**
	 * Set API servers for WPBakery.
	 */
	private function set_api_servers() {
		if ( class_exists( 'HPack_Set_API_Servers' ) ) {
			$w_p_bakery_updates_support = new HPack_Set_API_Servers();
			$w_p_bakery_updates_support->set_api_servers( 'support.wpbakery.com/check-license-key', HELLOPACK_LICENSE_MANAGER_SERVER . '/wpbakery/check-license-key?s=' );
			$w_p_bakery_updates_support->init();

			$w_p_bakery_updates_support = new HPack_Set_API_Servers();
			$w_p_bakery_updates_support->set_api_servers( 'support.wpbakery.com/finish-license-activation', HELLOPACK_LICENSE_MANAGER_SERVER . '/wpbakery/finish-license-activation?s=' );
			$w_p_bakery_updates_support->init();
		}
	}

	/**
	 * Activate WPBakery license.
	 */
	private function activate_license() {
		HP_check_options( 'wpb_license_errors', array() );
		HP_check_options( 'wpb_js_js_composer_purchase_code', HP_GLOBAL_SERIAL );
	}

	/**
	 * Disable upgrader pre-download.
	 */
	public function disable_upgrader_pre_download() {
		if ( function_exists( 'disable_upgrader_pre_download' ) ) {
			disable_upgrader_pre_download();
		}
	}
}