<?php
/**
 * MainWP Module
 *
 * @package HelloPack
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Class HelloPack_Module_MainWP
 */
class HelloPack_Module_MainWP extends HelloPack_Module_Base {

	/**
	 * Set up the module properties.
	 */
	protected function setup() {
		$this->id          = 'mainwp';
		$this->name        = 'MainWP';
		$this->description = __( 'Manages MainWP updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'mainwp',
			'plugin_file' => 'mainwp.php',
		);
	}

	/**
	 * Initialize the module functionality.
	 */
	public function init() {
		if ( ! $this->should_load() ) {
			return;
		}

		$this->set_api_servers();
		$this->activate_license();
	}

	/**
	 * Set API servers for MainWP.
	 */
	private function set_api_servers() {
		if ( class_exists( 'HPack_Set_API_Servers' ) ) {
			$mainwp_licensing = new HPack_Set_API_Servers();
			$mainwp_licensing->set_api_servers( 'mainwp.com/?mainwp-api=am-software-api', HELLOPACK_LICENSE_MANAGER_SERVER . '/mainwp/activate-license?s=' );
			$mainwp_licensing->init();
		}
	}

	/**
	 * Activate MainWP license.
	 */
	private function activate_license() {
		$plan_info = array(
			'plan_purchased' => 'yearly',
			'plan_status'    => 'active',
		);

		update_option( 'mainwp_extensions_plan_info', json_encode( $plan_info ) );
	}
}