<?php
/**
 * Meta Box Module
 *
 * @package HelloPack
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Class HelloPack_Module_Meta_Box
 */
class HelloPack_Module_Meta_Box extends HelloPack_Module_Base {

	/**
	 * Set up the module properties.
	 */
	protected function setup() {
		$this->id          = 'meta-box';
		$this->name        = 'Meta Box';
		$this->description = __( 'Manages Meta Box updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'meta-box',
			'plugin_file' => 'meta-box.php',
		);
	}

	/**
	 * Initialize the module functionality.
	 */
	public function init() {
		if ( ! $this->should_load() ) {
			return;
		}

		$this->activate_license();
	}

	/**
	 * Activate Meta Box license.
	 */
	private function activate_license() {
		HP_check_options(
			'meta_box_updater',
			array(
				'api_key' => HP_GLOBAL_SERIAL,
				'status'  => 'active',
			)
		);
	}
}