<?php
/**
 * Oxygen Composite Elements Module
 *
 * @package HelloPack
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Class HelloPack_Module_Oxy_Composite_Elements
 */
class HelloPack_Module_Oxy_Composite_Elements extends HelloPack_Module_Base {

	/**
	 * Set up the module properties.
	 */
	protected function setup() {
		$this->id          = 'oxy-composite-elements';
		$this->name        = 'Oxygen Composite Elements';
		$this->description = __( 'Manages Oxygen Composite Elements updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'oxygen',
			'plugin_file' => 'functions.php',
		);
	}

	/**
	 * Initialize the module functionality.
	 */
	public function init() {
		if ( ! $this->should_load() ) {
			return;
		}

		$this->set_api_servers();
	}

	/**
	 * Set API servers for Oxygen Builder.
	 */
	private function set_api_servers() {
		if ( class_exists( 'HPack_Set_API_Servers' ) ) {
			$oxygenbuilder = new HPack_Set_API_Servers();
			$oxygenbuilder->set_api_servers( 'oxygenbuilder.com?edd_action=activate_license&license=', HP_PLUGIN_API_SERVER . '/oxygenbuilder?=' );
			$oxygenbuilder->init();
		}
	}
}