<?php
/**
 * Perfmatters Module
 *
 * @package HelloPack_Client
 * @since 2.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Perfmatters module class.
 */
class HelloPack_Module_Perfmatters extends HelloPack_Module_Base {

	/**
	 * Setup module properties
	 */
	protected function setup() {
		$this->id          = 'perfmatters';
		$this->name        = __( 'Perfmatters', 'hellopack-client' );
		$this->description = __( 'Manages Perfmatters updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'perfmatters',
			'plugin_file' => 'perfmatters.php',
		);
	}

	/**
	 * Initialize the module
	 */
	public function init() {
		// Set Perfmatters license status
		$this->set_license_status();
	}

	/**
	 * Set Perfmatters license status
	 */
	private function set_license_status() {
		if ( function_exists( 'HP_check_options' ) ) {
			HP_check_options( 'perfmatters_edd_license_status', 'valid' );
		}
	}
}