<?php
/**
 * Product Extras for WooCommerce Module
 *
 * @package HelloPack_Client
 * @since 2.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Product Extras for WooCommerce module class.
 */
class HelloPack_Module_Product_Extras_For_WooCommerce extends HelloPack_Module_Base {

	/**
	 * Setup module properties
	 */
	protected function setup() {
		$this->id          = 'product-extras-for-woocommerce';
		$this->name        = __( 'Product Extras for WooCommerce', 'hellopack-client' );
		$this->description = __( 'Manages Product Extras for WooCommerce updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'product-extras-for-woocommerce',
			'plugin_file' => 'product-extras-for-woocommerce.php',
		);
	}

	/**
	 * Initialize the module
	 */
	public function init() {
		// Set license options
		$this->set_license_options();
		
		// Override API servers
		$this->override_api_servers();
	}

	/**
	 * Set license options
	 */
	private function set_license_options() {
		if ( function_exists( 'HP_check_options' ) ) {
			HP_check_options( 'pewc_license_status', 'valid' );
			HP_check_options( 'pewc_payment_id', '82200' );
			HP_check_options( 'pewc_license_id', '1100' );
			HP_check_options( 'pewc_license_level', '0' );
			HP_check_options( 'pewc_license_key', HP_GLOBAL_SERIAL );
			delete_option( 'pewc_license_status_message' );

			if ( get_option( 'pewc_license_level' ) == 1 ) {
				HP_check_options( 'pewc_license_level', '0' );
			}
		}
	}

	/**
	 * Override API servers
	 */
	private function override_api_servers() {
		if ( class_exists( 'HPack_Set_API_Servers' ) ) {
			$pewc_license = new HPack_Set_API_Servers();
			$pewc_license->over_api_servers( 'pluginrepublic.com' );
			$pewc_license->init();
		}
	}
}