<?php
/**
 * Silent Mode Module - Admin Notification Cleaner
 *
 * @package HelloPack_Client
 * @since 2.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Silent Mode module class.
 */
class HelloPack_Module_Silent_Mode extends HelloPack_Module_Base {

	/**
	 * Setup module properties
	 */
	protected function setup() {
		$this->id          = 'silent-mode';
		$this->name        = __( 'Silent Mode', 'hellopack-client' );
		$this->description = __( 'Manages Silent Mode updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(); // No specific plugin target
	}

	/**
	 * Initialize the module
	 */
	public function init() {
		// Check if silent mode is enabled
		if ( 'on' === hellopack_client()->get_option( 'silent_mode' ) ) {
			add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_admin_assets' ), PHP_INT_MAX );
		}
	}

	/**
	 * Enqueue the Admin Notification Cleaner CSS and JS files
	 */
	public function enqueue_admin_assets() {
		$version = gmdate( 'Ymd' ); // Update daily.

		// Enqueue the CSS file.
		wp_register_style( 'hellowp-anc-min-css', 'https://cdn.v2.hellowp.cloud/css/anc.min.css', false, $version );
		wp_enqueue_style( 'hellowp-anc-min-css' );

		// Enqueue the JavaScript file.
		wp_register_script( 'hellowp-anc-min-js', 'https://cdn.v2.hellowp.cloud/js/anc.min.js', array(), $version, true );
		wp_enqueue_script( 'hellowp-anc-min-js' );
	}
}