<?php
/**
 * Supreme Modules Pro for Divi Module
 *
 * @package HelloPack_Client
 * @since 2.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Supreme Modules Pro for Divi module class.
 */
class HelloPack_Module_Supreme_Modules_Pro_For_Divi extends HelloPack_Module_Base {

	/**
	 * Setup module properties
	 */
	protected function setup() {
		$this->id          = 'supreme-modules-pro-for-divi';
		$this->name        = __( 'Supreme Modules Pro for Divi', 'hellopack-client' );
		$this->description = __( 'Manages Supreme Modules Pro for Divi updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'supreme-modules-pro-for-divi',
			'plugin_file' => 'supreme-modules-pro-for-divi.php',
		);
	}

	/**
	 * Initialize the module
	 */
	public function init() {
		// Set DSM plugin status
		$this->set_plugin_status();
	}

	/**
	 * Set DSM plugin status
	 */
	private function set_plugin_status() {
		$license_data['key']        = HP_GLOBAL_SERIAL;
		$license_data['last_check'] = time();
		
		if ( function_exists( 'HP_check_options' ) ) {
			HP_check_options( 'dsm_pro_license', $license_data );
		}
	}
}