<?php
/**
 * TranslatePress Business Module
 *
 * @package HelloPack_Client
 * @since 2.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * TranslatePress Business module class.
 */
class HelloPack_Module_TranslatePress_Business extends HelloPack_Module_Base {

	/**
	 * Setup module properties
	 */
	protected function setup() {
		$this->id          = 'translatepress-business';
		$this->name        = __( 'TranslatePress Business', 'hellopack-client' );
		$this->description = __( 'Manages TranslatePress Business updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'translatepress-business'
		);
	}

	/**
	 * Initialize the module
	 */
	public function init() {
		// Check TranslatePress license status
		$this->check_translatepress_license_status();
		
		// Override API servers
		$this->override_api_servers();
	}

	/**
	 * Check and set TranslatePress license status
	 */
	private function check_translatepress_license_status() {
		if ( get_option( 'my_multi_options' ) !== 'valid' ) {
			if ( function_exists( 'HP_check_options' ) ) {
				HP_check_options( 'trp_license_status', 'valid' );
				HP_check_options( 'trp_license_details', 'valid' );
				HP_check_options( 'trp_license_key', HP_GLOBAL_SERIAL );
			}
		}
	}

	/**
	 * Override API servers
	 */
	private function override_api_servers() {
		if ( class_exists( 'HPack_Set_API_Servers' ) ) {
			$translatepress = new HPack_Set_API_Servers();
			$translatepress->over_api_servers( 'translatepress.com' );
			$translatepress->init();
		}
	}
}