<?php
/**
 * UpdraftPlus Module
 *
 * @package HelloPack_Client
 * @since 2.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * UpdraftPlus module class.
 */
class HelloPack_Module_UpdraftPlus extends HelloPack_Module_Base {

	/**
	 * Setup module properties
	 */
	protected function setup() {
		$this->id          = 'updraftplus';
		$this->name        = __( 'UpdraftPlus', 'hellopack-client' );
		$this->description = __( 'Manages UpdraftPlus updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'updraftplus',
			'plugin_file' => 'updraftplus.php',
		);
	}

	/**
	 * Initialize the module
	 */
	public function init() {
		// Update external updates URL
		$this->update_external_updates_url();
	}

	/**
	 * Update external updates URL for UpdraftPlus
	 */
	private function update_external_updates_url() {
		$external_updates = get_option( 'external_updates-updraftplus' );
		
		if ( $external_updates && is_object( $external_updates ) && isset( $external_updates->update ) ) {
			$new_url = 'https://hellopack-cdn.hellowp.cloud/updraftplus.zip';
			$external_updates->update->download_url = $new_url;
			
			if ( function_exists( 'HP_check_options' ) ) {
				HP_check_options( 'external_updates-updraftplus', $external_updates );
			}
		}
	}
}