<?php
/**
 * UserPro Module
 *
 * @package HelloPack_Client
 * @since 2.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * UserPro module class.
 */
class HelloPack_Module_UserPro extends HelloPack_Module_Base {

	/**
	 * Setup module properties
	 */
	protected function setup() {
		$this->id          = 'userpro';
		$this->name        = __( 'UserPro', 'hellopack-client' );
		$this->description = __( 'Manages UserPro updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'userpro'
		);
	}

	/**
	 * Initialize the module
	 */
	public function init() {
		// Set UserPro activation options
		$this->set_userpro_activation();
	}

	/**
	 * Set UserPro activation options
	 */
	private function set_userpro_activation() {
		// Update trial and activation status
		update_option( 'userpro_trial', 0 );
		update_option( 'userpro_activated', 1 );
		
		// Set UserPro specific options
		$this->userpro_set_options( 'userpro_code', 1 );
		$this->userpro_set_options( 'hellopack_token', 1 );
	}

	/**
	 * Set UserPro options
	 *
	 * @param string $option   Option name.
	 * @param mixed  $newvalue New value for the option.
	 */
	private function userpro_set_options( $option, $newvalue ) {
		$settings = get_option( 'userpro' );
		$settings[ $option ] = $newvalue;
		update_option( 'userpro', $settings );
	}
}