<?php
/**
 * WooCommerce Appointments Module
 *
 * @package HelloPack_Client
 * @since 2.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * WooCommerce Appointments module class.
 */
class HelloPack_Module_WooCommerce_Appointments extends HelloPack_Module_Base {

	/**
	 * Setup module properties
	 */
	protected function setup() {
		$this->id          = 'woocommerce-appointments';
		$this->name        = __( 'WooCommerce Appointments', 'hellopack-client' );
		$this->description = __( 'Manages WooCommerce Appointments updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'woocommerce-appointments',
			'plugin_file' => 'woocommerce-appointments.php',
		);
	}

	/**
	 * Initialize the module
	 */
	public function init() {
		// Set license status
		$this->set_license_status();
	}

	/**
	 * Set WooCommerce Appointments license status
	 */
	private function set_license_status() {
		if ( function_exists( 'HP_check_options' ) ) {
			HP_check_options( 'bizz_woocommerce_appointments_license_active', 'valid' );
		}
	}
}