<?php
/**
 * WooCommerce Pretty Emails Module
 *
 * @package HelloPack_Client
 * @since 2.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * WooCommerce Pretty Emails module class.
 */
class HelloPack_Module_WooCommerce_Pretty_Emails extends HelloPack_Module_Base {

	/**
	 * Setup module properties
	 */
	protected function setup() {
		$this->id          = 'woocommerce-pretty-emails';
		$this->name        = __( 'WooCommerce Pretty Emails', 'hellopack-client' );
		$this->description = __( 'Manages WooCommerce Pretty Emails updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'woocommerce-pretty-emails',
			'plugin_file' => 'emailplus.php',
		);
	}

	/**
	 * Initialize the module
	 */
	public function init() {
		// Override API servers
		$this->override_api_servers();
	}

	/**
	 * Override API servers
	 */
	private function override_api_servers() {
		if ( class_exists( 'HPack_Set_API_Servers' ) ) {
			$pretty_emails = new HPack_Set_API_Servers();
			$pretty_emails->over_api_servers( 'www.mbcreation.com' );
			$pretty_emails->init();
		}
	}
}