<?php
/**
 * WP Booking System Premium Module
 *
 * @package HelloPack_Client
 * @since 2.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * WP Booking System Premium module class.
 */
class HelloPack_Module_WP_Booking_System_Premium extends HelloPack_Module_Base {

	/**
	 * Setup module properties
	 */
	protected function setup() {
		$this->id          = 'wp-booking-system-premium';
		$this->name        = __( 'WP Booking System Premium', 'hellopack-client' );
		$this->description = __( 'Manages WP Booking System Premium updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'wp-booking-system-premium'
		);
	}

	/**
	 * Initialize the module
	 */
	public function init() {
		// Set license options
		$this->set_wpbs_license_options();
		
		// Override API servers
		$this->override_api_servers();
		
		// Remove addons submenu
		add_action( 'admin_menu', array( $this, 'remove_wpbs_calendars_submenu' ), 999 );
	}

	/**
	 * Set WP Booking System license options
	 */
	private function set_wpbs_license_options() {
		if ( function_exists( 'HP_check_options' ) ) {
			HP_check_options( 'wpbs_registered_website_id', HP_GLOBAL_SERIAL );
			HP_check_options( 'wpbs_serial_key', HP_GLOBAL_SERIAL );
		}
	}

	/**
	 * Override API servers
	 */
	private function override_api_servers() {
		if ( class_exists( 'HPack_Set_API_Servers' ) ) {
			$bookingsys = new HPack_Set_API_Servers();
			$bookingsys->over_api_servers( 'www.wpbookingsystem.com/u/' );
			$bookingsys->init();
		}
	}

	/**
	 * Remove WP Booking System addons submenu
	 */
	public function remove_wpbs_calendars_submenu() {
		remove_submenu_page( 'wp-booking-system', 'wpbs-addons' );
	}
}