<?php
/**
 * HelloPack Module: WP Grid Builder
 *
 * @package HelloPack
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Class HelloPack_Module_WP_Grid_Builder
 *
 * Module for managing WP Grid Builder plugin functionality
 */
class HelloPack_Module_WP_Grid_Builder extends HelloPack_Module_Base {

	/**
	 * Module setup
	 *
	 * @return void
	 */
	public function setup() {
		$this->id          = 'wp-grid-builder';
		$this->name        = 'WP Grid Builder';
		$this->description = __( 'Manages WP Grid Builder updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'wp-grid-builder',
			'plugin_file' => 'wp-grid-builder.php',
		);
	}

	/**
	 * Module initialization
	 *
	 * @return void
	 */
	public function init() {
		if ( ! $this->should_load() ) {
			return;
		}

		add_action( 'admin_init', array( $this, 'disable_upgrader_pre_download' ) );
		add_action( 'admin_menu', array( $this, 'remove_grid_builder_submenu' ), 999 );

		// Check grid builder status directly without plugins_loaded hook
		$this->check_grid_builder_status();
	}

	/**
	 * Disable upgrader pre download
	 *
	 * @return void
	 */
	public function disable_upgrader_pre_download() {
		// Implementation needed - original file doesn't show this function
	}

	/**
	 * Remove Grid Builder submenu
	 *
	 * @return void
	 */
	public function remove_grid_builder_submenu() {
		remove_submenu_page( 'wpgb', 'wpgb-add-ons' );
	}

	/**
	 * Check Grid Builder status
	 *
	 * @return void
	 */
	public function check_grid_builder_status() {
		if ( ! get_option( 'wpgb_plugin_info' ) || get_option( 'wpgb_plugin_info' ) !== get_option( 'wpgb_plugin_info_backup' ) ) {
			$json_url = HP_PLUGIN_REGISTER_SERVER_HTTPS . '/wpgridbuilder';
			$response = wp_remote_get( $json_url );
			if ( is_array( $response ) && ! is_wp_error( $response ) ) {
				$json_data = wp_remote_retrieve_body( $response );
				$data_ser  = json_decode( $json_data, true );
				HP_check_options( 'wpgb_plugin_info', $data_ser );
				HP_check_options( 'wpgb_plugin_info_backup', $data_ser );
			}
		}
	}
}