<?php
/**
 * HelloPack Module: YITH WooCommerce Ajax Product Filter Premium
 *
 * @package HelloPack
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Class HelloPack_Module_YITH_WooCommerce_Ajax_Product_Filter_Premium
 *
 * Module for managing YITH WooCommerce Ajax Product Filter Premium plugin functionality
 */
class HelloPack_Module_YITH_WooCommerce_Ajax_Product_Filter_Premium extends HelloPack_Module_Base {

	/**
	 * Module setup
	 *
	 * @return void
	 */
	public function setup() {
		$this->id          = 'yith-woocommerce-ajax-product-filter-premium';
		$this->name        = 'YITH WooCommerce Ajax Product Filter Premium';
		$this->description = __( 'Manages YITH WooCommerce Ajax Product Filter Premium updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'yith-woocommerce-ajax-product-filter-premium',
			'plugin_file' => 'init.php',
		);
	}

	/**
	 * Module initialization
	 *
	 * @return void
	 */
	public function init() {
		if ( ! $this->should_load() ) {
			return;
		}

		// Set up YITH license data
		$this->setup_yith_license();

		// Set up API servers
		$fw_licensing_check = new HPack_Set_API_Servers();
		$fw_licensing_check->set_api_servers( 'licence.yithemes.com/api/check', HELLOPACK_LICENSE_MANAGER_SERVER . '/yith/activate-license?s=' );
		$fw_licensing_check->init();

		$fw_licensing_activation = new HPack_Set_API_Servers();
		$fw_licensing_activation->set_api_servers( 'licence.yithemes.com/api/activation', HELLOPACK_LICENSE_MANAGER_SERVER . '/yith/activate-license?s=' );
		$fw_licensing_activation->init();

		add_action( 'admin_init', array( $this, 'disable_upgrader_pre_download' ), PHP_INT_MAX );
	}

	/**
	 * Set up YITH license data
	 *
	 * @return void
	 */
	private function setup_yith_license() {
		$yith_data = array(
			'email'                => 'support@hellowp.io',
			'licence_key'          => 'e2f1c3de-5a2b-4e7e-ae2d-98acd1304f17',
			'licence_expires'      => strtotime( '+1 year' ),
			'message'              => '0 out of 1 activations remaining',
			'activated'            => true,
			'activation_limit'     => 1,
			'activation_remaining' => 0,
			'is_membership'        => false,
			'marketplace'          => 'yith',
			'status_code'          => '200',
			'licence_next_check'   => strtotime( '+1 year' ),
		);

		$option = get_option( 'yit_plugin_licence_activation' );

		if ( is_array( $option ) && isset( $option['yith-woocommerce-ajax-navigation'] ) ) {
			$option['yith-woocommerce-ajax-navigation'] = array_merge( $option['yith-woocommerce-ajax-navigation'], $yith_data );
		} elseif ( ! is_array( $option ) ) {
			$option = array( 'yith-woocommerce-ajax-navigation' => $yith_data );
		} else {
			$option['yith-woocommerce-ajax-navigation'] = $yith_data;
		}

		update_option( 'yit_plugin_licence_activation', $option );
	}

	/**
	 * Disable upgrader pre download
	 *
	 * @return void
	 */
	public function disable_upgrader_pre_download() {
		// Implementation needed - original file references this function but doesn't show implementation
	}
}